/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.websm.launch.hscmgt.Efix;
import com.ibm.hsc.websm.launch.hscmgt.EfixException;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class HMCUpdate
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private static final String MEDIA_TYPE = "m";
    private static final String SERVER_TYPE = "s";
    private static final String LOCAL_FS = "l";
    private static final Integer REMOVABLE_MEDIA = new Integer(0);
    private static final Integer LOCAL_MEDIA = new Integer(1);
    private Hashtable inParams;
    private String file;
    private String hostNameIP;
    private String interFlag;
    private String machineHostName;
    private String password;
    private String rebootFlag;
    private String updateType;
    private String userId;
    private boolean removeFile;
    private HSCClientObjectFactory hcof;
    private boolean writeStatus;
    private PrintStream output;

    public HMCUpdate(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void initializeClients() throws HSCException {
        try {
            this.machineHostName = InetAddress.getLocalHost().getHostName();
            this.hcof = HSCClientObjectFactory.getInstance(this.machineHostName, "root/ibmhscV3_2");
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.updateType) {
            objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")"};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.updateType.equals(LOCAL_FS) && null == this.file) {
            objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.FILE_PARAM + ", "};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.TYPE_PARAM + "," + HMCCommandUtils.FILE_PARAM + ", " + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.updateType.equals(SERVER_TYPE) && (null == this.hostNameIP || null == this.userId || null == this.file || null == this.interFlag && null == this.password)) {
            objectArray = new String[]{HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.HOSTNAME_PARAM + ", " + HMCCommandUtils.FILE_PARAM + ", " + HMCCommandUtils.USER_ID_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.PASSWORD_PARAM + " or " + HMCCommandUtils.INTERACTIVE_PARAM + ")"};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.TYPE_PARAM + ", " + HMCCommandUtils.HOSTNAME_PARAM + ", " + HMCCommandUtils.FILE_PARAM + ", " + HMCCommandUtils.USER_ID_PARAM + ", and " + " (" + HMCCommandUtils.PASSWORD_PARAM + " or " + HMCCommandUtils.INTERACTIVE_PARAM + ")" + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException, HSCException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (!(this.updateType == null || this.updateType.equals(MEDIA_TYPE) || this.updateType.equals(LOCAL_FS) || this.updateType.equals(SERVER_TYPE))) {
            objectArray = new String[]{"m,l " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + SERVER_TYPE};
            string = "There is an invalid resource type entered. The valid values are m,l and s. Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_INVALID_RESOURCE_TYPE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        String string = null;
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        try {
            if (this.updateType.equals(MEDIA_TYPE)) {
                Efix.installCSD(REMOVABLE_MEDIA, null);
            } else if (this.updateType.equals(SERVER_TYPE)) {
                Efix.downloadFix(this.hostNameIP, this.file, this.userId, this.password, null);
                Efix.installCSD(LOCAL_MEDIA, null);
            } else if (this.updateType.equals(LOCAL_FS)) {
                if (this.removeFile) {
                    Efix.installCSD(this.file, "remove", null);
                } else {
                    Efix.installCSD(this.file, null, null);
                }
            }
            string = "/opt/hsc/bin/hmcshutdown";
            if (null != this.rebootFlag) {
                string = "/opt/hsc/bin/hmcshutdown -t now -r";
                Process process = Runtime.getRuntime().exec(string);
                int n = process.waitFor();
            }
        }
        catch (EfixException efixException) {
            String string2 = efixException.getKey();
            String string3 = null;
            String string4 = null;
            if (string2.equals("0125")) {
                string4 = "An incorrect user ID and password combination was entered. Specify a valid user ID and password and retry ythe command.";
                string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_UPDATE_HMC_WRONG_PASSWORD", string4, null);
                throw new RequiredParameterException(string3);
            }
            if (string2.equals("0126")) {
                string4 = "The corrective service file was not found on the server. Ensure the correct fully qualified path and filename has been specified for the file parameter and retry the command.";
                string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_UPDATE_HMC_WRONG_PASSWORD", string4, null);
                throw new RequiredParameterException(string3);
            }
            if (string2.equals("0127")) {
                string4 = "An error occurred while unpacking the corrective service file. The file may be corrupt, or the HMC may have run out of disk space. Please retry the command.";
                string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_UPDATE_HMC_FILE_CORRUPT", string4, null);
                throw new RequiredParameterException(string3);
            }
            if (string2.equals("0046")) {
                string4 = "An error occurred while attempting to remotely connect to the server. Please retry the command.";
                string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SERVER_NOT_FOUND", string4, null);
                throw new RequiredParameterException(string3);
            }
            string4 = "An error occurred while trying to run corrective services. Please check your entry and retry command.";
            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_UPDATE_HMC_GENERAL", string4, null);
            throw new RequiredParameterException(string3);
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        EExecResult eExecResult = null;
        Object var3_3 = null;
        String string = null;
        String string2 = null;
        String string3 = System.getProperty("HMCtty.name");
        this.file = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
        this.hostNameIP = (String)hashMap.get(HMCCommandUtils.HOSTNAME_PARAM);
        this.interFlag = (String)hashMap.get(HMCCommandUtils.INTERACTIVE_PARAM);
        this.password = (String)hashMap.get(HMCCommandUtils.PASSWORD_PARAM);
        this.rebootFlag = (String)hashMap.get(HMCCommandUtils.REBOOT_PARAM);
        this.updateType = (String)hashMap.get(HMCCommandUtils.TYPE_PARAM);
        this.userId = (String)hashMap.get(HMCCommandUtils.USER_ID_PARAM);
        String string4 = (String)hashMap.get(HMCCommandUtils.CLEANUP_FILE);
        this.removeFile = string4 != null;
        if (null != this.interFlag) {
            try {
                if (string3 != null && string3 != "") {
                    eExecResult = EExec.Exec((String)("stty --save --file=" + string3));
                    string2 = "stty --file=" + string3 + " " + eExecResult.stdout;
                    string = "stty --file=" + string3 + " -echo";
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HMC_PASSWORD", "Password:", null));
                eExecResult = EExec.Exec(string);
                this.password = bufferedReader.readLine().trim();
                eExecResult = EExec.Exec(string2);
                bufferedReader.close();
            }
            catch (Exception exception) {
                throw new RequiredParameterException("An error occurred while entering the password. Please retry the command.");
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HMC_UPDATE_HELP"));
    }

    public static void main(String[] stringArray) {
        HMCUpdate hMCUpdate = new HMCUpdate(true);
        int n = hMCUpdate.process(stringArray);
        System.exit(n);
    }

    public static void entryMethod(String[] stringArray) {
        HMCUpdate hMCUpdate = new HMCUpdate(false);
        hMCUpdate.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                hSCException.printStackTrace(this.output);
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace(this.output);
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                exception.printStackTrace(this.output);
            }
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

